;**********************************************************
;   (c) by Knobloch GmbH
;       Weedgasse 14 
;       D-55234 Erbes-Bdesheim                                    
;
;   Includefile:    sect30.inc      Includefile fr NCRT0.A30 
;                                   Section definitions
;
;   Version:        0.03
;
;   Revision:
;   0.01:   16.11.2005
;           Start
;   0.02:   12.05.2006
;           Data and code area changed
;   0.03:   13.05.2006
;           Data area changed
;**********************************************************


;---------------------------------------------------------------
; Near RAM data area (SBDATA area)
;---------------------------------------------------------------
    .section    TA_COMMUNICATION_NE,DATA
    .org    400H                ;Section is from 00400h - 005FFh
                                ;for Transfer-Area


	.section	BITRAM_START,DATA    
	.org	600H                ;Section is from 00600h - 011FFh 
                                ;for bitadressable data
                                ;(not used in this example)


	.section	data_SE,DATA    
	.org	04000H              ;Section is from 04000h - 0FFFFh 
data_SE_top:                    ;SBDATA Even data size (with initial values)

	.section	bss_SE,DATA,ALIGN
bss_SE_top:                     ;SBDATA Even data size (without initial values)

	.section	data_SO,DATA
data_SO_top:                    ;SBDATA Odd data size (with initial values)

	.section	bss_SO,DATA
bss_SO_top:                     ;SBDATA Odd data size (without initial values)

	.section	data_NE,DATA,ALIGN
data_NE_top:                    ;near data with even data Size (with initial values)

	.section	bss_NE,DATA,ALIGN
bss_NE_top:                     ;near data with even data Size (without initial values)

	.section	data_NO,DATA
data_NO_top:                    ;near data with odd data Size (with initial values)

	.section	bss_NO,DATA
bss_NO_top:                     ;near data with odd data Size (without initial values)

;---------------------------------------------------------------
;	heap section
;---------------------------------------------------------------
;    .section	heap,DATA
;    heap_top:
;    .blkb	HEAPSIZE


; Normaly you can use the Robo Interface Stack (you find the size in NCRT0.A30)
; If you will use your own stack, you must use the following lines
; Dont forget to re-comment the "STACKSIZE" and "ISTACKSIZE"
; lines in the NCRT0.A30 File!
;
    ;---------------------------------------------------------------
    ; Stack area
    ;---------------------------------------------------------------
	;   .section	stack,DATA
	;   .blkb	STACKSIZE
    ;   stack_top:
    ;
    ;	.blkb	ISTACKSIZE
    ;istack_top:
    ;
    ;---------------------------------------------------------------
    ; Near ROM data area
    ;---------------------------------------------------------------
    ;	.section	rom_NE,ROMDATA,ALIGN
    ;   rom_NE_top:
    ;
    ;	.section	rom_NO,ROMDATA
    ;   rom_NO_top:
    

;---------------------------------------------------------------
; Far RAM data area (if Prog uses Flash1 or Flash2)
;---------------------------------------------------------------
.if	FAR_RAM_ADR == 0
	.section	data_FE,DATA
	.org		START_ADR_F_RAM
data_FE_top:

	.section	bss_FE,DATA,ALIGN
bss_FE_top:
 
	.section	data_FO,DATA
data_FO_top:
 
	.section	bss_FO,DATA
bss_FO_top:
.endif


;---------------------------------------------------------------
; code area
;---------------------------------------------------------------
	.section	program
    .org        START_PROG_ADR

	.section	interrupt

;---------------------------------------------------------------
; Far ROM data area
;---------------------------------------------------------------
	.section	rom_FE,ROMDATA
rom_FE_top:

	.section	rom_FO,ROMDATA
rom_FO_top:

;---------------------------------------------------------------
; Initial data of 'data' section
;---------------------------------------------------------------
	.section	data_SEI,ROMDATA
data_SEI_top:

	.section	data_SOI,ROMDATA
data_SOI_top:

	.section	data_NEI,ROMDATA
data_NEI_top:
 
	.section	data_NOI,ROMDATA
data_NOI_top:
 
	.section	data_FEI,ROMDATA
data_FEI_top:
 
	.section	data_FOI,ROMDATA
data_FOI_top:


;---------------------------------------------------------------
; Far RAM data area (if Prog uses RAM1)
;---------------------------------------------------------------
.if	FAR_RAM_ADR == 1
	.section	data_FE,DATA
    .blkd       19
    .blkw       2
data_FE_top:

	.section	bss_FE,DATA,ALIGN
bss_FE_top:
 
	.section	data_FO,DATA
data_FO_top:
 
	.section	bss_FO,DATA
bss_FO_top:
.endif


;---------------------------------------------------------------
; Switch Table Section
;---------------------------------------------------------------
	.section    switch_table,ROMDATA
switch_table_top:


;---------------------------------------------------------------
; variable vector section
;---------------------------------------------------------------
;	.section	vector,ROMDATA	; variable vector table
;	.org	VECTOR_ADR 

	

; End of File